#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_PatientOrder : BaseTest 
	{
		private BOL.PatientOrder _tstPO;

		private Guid __tstPOGuid;
		private Guid _patientGuid;
		private Guid _patientTreatmentGuid;
		private string _orderGroupNumber;
		

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				string sSQL = " SELECT TOP " +
							" 1 * FROM PatientOrder PO " +
							" 	JOIN PatientTreatment PT ON PT.PatientTreatmentGuid = PO.PatientTreatmentGuid " +
							" 	JOIN PatientSpecimen PS	ON PT.PatientGUID = PS.PatientGUID " +
							" 	JOIN OrderedTest OT ON PS.PatientSpecimenGUID = OT.PatientSpecimenGUID " +
							" WHERE "+
							" 	PO.DivisionCode = '" + this.TestDivisionCode + "' AND PO.OrderPlacedDateTime IS NOT NULL AND OrderGroupNumber IS NOT NULL ";
				
				//string sSQL = "SELECT TOP 1 * FROM PatientOrder JOIN PatientTreatment ON PatientTreatment.PatientTreatmentGuid = PatientOrder.PatientTreatmentGuid WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND OrderGroupNumber IS NOT NULL";

				DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL, true);

				__tstPOGuid	= (Guid) dtTemp.Rows[0][TABLES.PatientOrder.PatientOrderGuid];
				_patientGuid		= (Guid) dtTemp.Rows[0][TABLES.PatientTreatment.PatientGuid];
				_orderGroupNumber	= (String) dtTemp.Rows[0][TABLES.PatientOrder.OrderGroupNumber];
				_patientTreatmentGuid = (Guid) dtTemp.Rows[0][TABLES.PatientTreatment.PatientTreatmentGuid];

				this.RefreshData = false;
			}
			
			_tstPO = new gov.va.med.vbecs.BOL.PatientOrder(__tstPOGuid,false);
		}


		[Test]
		public void Ctor_DataRow_Pass()
		{
			DataTable dt = BOL.OrderedComponent.GetComponentOrders();
			Guid _tstPOGuid = (Guid) dt.Rows[0][TABLES.PatientOrder.PatientOrderGuid];

			_tstPO = new BOL.PatientOrder(dt.Rows[0]);
			Assert.AreEqual(_tstPO.PatientOrderGuid, _tstPOGuid);

		}
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void Ctor_Guid_Bool_Pass()
		{
			_tstPO = new BOL.PatientOrder(this.__tstPOGuid, true);
			
			Assert.AreEqual(this.__tstPOGuid, _tstPO.PatientOrderGuid);
		}
		

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Guid_Bool_Fail()
		{
		}

		[Test]
		public void Ctor_Guid_Pass()
		{
			_tstPO = new BOL.PatientOrder(this.__tstPOGuid);

			Assert.AreEqual(this.__tstPOGuid, _tstPO.PatientOrderGuid);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Guid_Fail()
		{
		}


		[Test]
		public void PatientAdmittingDiagnosis_Pass()
		{
			//PatientTreatment has the PatientAdmittingDiagnosis column on it, and the DataRow constructor is the only
			//way to get a value into this property
			DataRow dr = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM PatientTreatment");
			BOL.PatientOrder tmpPO = new BOL.PatientOrder(dr);

			string tstValue = string.Empty;

			if (!dr.IsNull(TABLES.PatientTreatment.PatientAdmittingDiagnosis))
				tstValue = dr[TABLES.PatientTreatment.PatientAdmittingDiagnosis].ToString();

			Assert.AreEqual(tstValue, tmpPO.PatientAdmittingDiagnosis, "InitialValue");

			tstValue = System.DateTime.Now.ToString();
			tmpPO.PatientAdmittingDiagnosis = tstValue;
			Assert.AreEqual(tstValue, tmpPO.PatientAdmittingDiagnosis, "Set Value");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void PatientAdmittingDiagnosis_Fail()
		{
			//PatientTreatment has the PatientAdmittingDiagnosis column on it, and the DataRow constructor is the only
			//way to get a value into this property
			DataRow dr = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM PatientTreatment");
			BOL.PatientOrder tmpPO = new BOL.PatientOrder(dr);

			tmpPO.PatientAdmittingDiagnosis = string.Empty;
		}

		[Test]
		public void TreatingSpecialtyName_Pass()
		{
			_tstPO.TreatingSpecialtyName = "Foo";
			Assert.IsTrue(_tstPO.TreatingSpecialtyName!=null && _tstPO.TreatingSpecialtyName=="Foo");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void TreatingSpecialtyName_Fail()
		{
			_tstPO.TreatingSpecialtyName = string.Empty;
		}

		[Test]
		public void PatientOrderGuid_Pass()
		{
			System.Guid _PatientOrderGuid;
			_PatientOrderGuid = _tstPO.PatientOrderGuid;
			Assert.AreEqual(_tstPO.PatientOrderGuid,_PatientOrderGuid);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void PatientOrderGuid_Fail()
		{
			this._tstPO.PatientOrderGuid = Guid.Empty;
		}

		[Test]
		public void PatientGuid_Pass()
		{
			System.Guid _PatientGuid;
			_PatientGuid = _tstPO.PatientGuid;
			Assert.AreEqual(_tstPO.PatientGuid,_PatientGuid);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void PatientGuid_Fail()
		{
			this._tstPO.PatientGuid = Guid.Empty;
		}

        [Test]
        public void Patient_Pass()
        {
            _tstPO = new gov.va.med.vbecs.BOL.PatientOrder(__tstPOGuid, false);	//trying to counteract the patient being overwritten

            gov.va.med.vbecs.BOL.Patient _Patient = _tstPO.Patient;

            Assert.AreEqual(_tstPO.Patient.PatientGuid, _Patient.PatientGuid);
        }

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Patient_Fail()
		{
		}

		[Test]
		public void OrderPlacedDateTime_Pass()
		{
			System.DateTime _OrderPlacedDateTime;
			_OrderPlacedDateTime = _tstPO.OrderPlacedDatetime;
			Assert.AreEqual(_tstPO.OrderPlacedDatetime,_OrderPlacedDateTime);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void OrderPlacedDateTime_Fail()
		{
			_tstPO.OrderPlacedDatetime = System.DateTime.MinValue;
		}

		[Test]
		public void OrderReceivedDateTime_Pass()
		{
			System.DateTime _OrderReceivedDateTime;
			_OrderReceivedDateTime = _tstPO.OrderReceivedDateTime;
			Assert.AreEqual(_tstPO.OrderReceivedDateTime,_OrderReceivedDateTime);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void OrderReceivedDateTime_Fail()
		{
			_tstPO.OrderReceivedDateTime = System.DateTime.MinValue;
		}

		[Test]
		public void OrderGroupNumber_Pass()
		{
			String _OrderGroupNumber;
			_OrderGroupNumber = _tstPO.OrderGroupNumber;
			Assert.AreEqual(_tstPO.OrderGroupNumber,_OrderGroupNumber);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void OrderGroupNumber_Fail()
		{
			_tstPO.OrderGroupNumber = null;
		}

		[Test]
		public void OrderingProviderID_Pass()
		{
			string _OrderingProviderID;
			_OrderingProviderID = _tstPO.OrderingProviderId;
			Assert.AreEqual(_tstPO.OrderingProviderId,_OrderingProviderID);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void OrderingProviderID_Fail()
		{
			_tstPO.OrderingProviderId = string.Empty;
		}

		[Test]
		public void OrderingProviderFirstName_Pass()
		{
			System.String _OrderingProviderFirstName = _tstPO.OrderingProviderFirstName;
			Assert.AreEqual(_tstPO.OrderingProviderFirstName,_OrderingProviderFirstName);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void OrderingProviderFirstName_Fail()
		{
			_tstPO.OrderingProviderFirstName = null;
		}

		[Test]
		public void OrderingProviderMiddleInitial_Pass()
		{
			System.String _OrderingProviderMiddleInitial = _tstPO.OrderingProviderMiddleInitial;
			Assert.AreEqual(_tstPO.OrderingProviderMiddleInitial,_OrderingProviderMiddleInitial);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void OrderingProviderMiddleInitial_Fail()
		{
			_tstPO.OrderingProviderMiddleInitial = null;
		}

		[Test]
		public void OrderingProviderLastName_Pass()
		{
			System.String _OrderingProviderLastName = _tstPO.OrderingProviderLastName;
			Assert.AreEqual(_tstPO.OrderingProviderLastName, _OrderingProviderLastName);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void OrderingProviderLastName_Fail()
		{
			_tstPO.OrderingProviderLastName = null;
		}

		[Test]
		public void OrderEnteredByFirstName_Pass()
		{
			System.String _OrderingProviderFirstName = _tstPO.OrderingProviderFirstName;
			Assert.AreEqual(_tstPO.OrderingProviderFirstName, _OrderingProviderFirstName);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void OrderEnteredByFirstName_Fail()
		{
			_tstPO.OrderingProviderFirstName = null;
		}

		[Test]
		public void OrderEnteredByMiddleInitial_Pass()
		{
			System.String _OrderEnteredByMiddleInitial = _tstPO.OrderEnteredByMiddleInitial;
			Assert.AreEqual(_tstPO.OrderEnteredByMiddleInitial, _OrderEnteredByMiddleInitial);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void OrderEnteredByMiddleInitial_Fail()
		{
			_tstPO.OrderEnteredByMiddleInitial = null;
		}
		
		[Test]
		public void OrderEnteredByLastName_Pass()
		{
			System.String _OrderEnteredByLastName = _tstPO.OrderEnteredByLastName;
			Assert.AreEqual(_tstPO.OrderEnteredByLastName, _OrderEnteredByLastName);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void OrderEnteredByLastName_Fail()
		{
			_tstPO.OrderEnteredByLastName = null;
		}

		[Test]
		public void OrderEnteredByID_Pass()
		{
			string _OrderEnteredByID = _tstPO.OrderEnteredById;
			Assert.AreEqual(_tstPO.OrderEnteredById, _OrderEnteredByID);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void OrderEnteredByID_Fail()
		{
			_tstPO.OrderEnteredById = string.Empty;
		}

		[Test]
		public void OrderingHospitalLocation_Pass()
		{
			System.String _OrderingHospitalLocation;
			_OrderingHospitalLocation = _tstPO.OrderingHospitalLocation;
			Assert.AreEqual(_tstPO.OrderingHospitalLocation,_OrderingHospitalLocation);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void OrderingHospitalLocation_Fail()
		{
			_tstPO.OrderingHospitalLocation = null;
		}

		[Test]
		public void EnteredBy_Pass()
		{
			System.String _EnteredBy;
			_EnteredBy = _tstPO.EnteredBy;
			Assert.AreEqual(_tstPO.EnteredBy,_EnteredBy);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void EnteredBy_Fail()
		{
		}

		[Test]
		public void RequestReason_Pass()
		{
			System.String _ReasonForRequest;
			_ReasonForRequest = _tstPO.RequestReason; 			
			Assert.AreEqual(_tstPO.RequestReason,_ReasonForRequest);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void RequestReasont_Fail()
		{
			_tstPO.RequestReason = null;
		}

		[Test]
		public void OrderComments_Pass()
		{
			System.String _OrderComments;
			_OrderComments = _tstPO.OrderComments; 			
			Assert.AreEqual(_tstPO.OrderComments,_OrderComments);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void OrderComments_Fail()
		{
			_tstPO.OrderComments = null;
		}

		[Test]
		public void InformedConsentIndicator_Pass()
		{
			System.Boolean _InformedConsentIndicator;
			_InformedConsentIndicator = _tstPO.InformedConsentIndicator; 			
			Assert.AreEqual(_tstPO.InformedConsentIndicator,_InformedConsentIndicator);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InformedConsentIndicator_Fail()
		{
		}

		[Test]
		public void SurgeryName_Pass()
		{
			System.String _SurgeryName;
			_SurgeryName = _tstPO.SurgeryName; 			
			Assert.AreEqual(_tstPO.SurgeryName,_SurgeryName);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void SurgeryName_Fail()
		{
			_tstPO.SurgeryName = null;
		}

		[Test]
		public void GetOrderSearchDetails_Pass()
		{
			System.DateTime now = System.DateTime.Now;

			DataTable dtTest = BOL.PatientOrder.GetOrderSearchDetails(now.AddYears(-1), now.AddYears(1), string.Empty, this._tstPO.Patient.SSN, this._tstPO.Patient.LastName);

			Assert.IsTrue(dtTest.Rows.Count >= 0, "Rows.Count");
		}

		[Test]
		[ExpectedException(typeof(NoRecordsFoundException))]
		public void GetOrderSearchDetails_Fail()
		{
			System.DateTime now = System.DateTime.Now;

			BOL.PatientOrder.GetOrderSearchDetails(now.AddYears(1), now.AddYears(-1), "1234567", "806872355", "Simpson");
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataTable dtTest = new DataTable();

			Assert.IsNull(this._tstPO.LoadDataRowFromThis(dtTest.NewRow()));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}


		[Test]
		public void GetOrderUrgencyList_Pass()
		{
			DataTable dt = BOL.PatientOrder.GetOrderUrgencyList();
			Assert.IsTrue(dt.Rows.Count > 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderUrgencyList_Fail()
		{
		}

		[Test]
		public void InitializePatientOrderTable_Pass()
		{
			DataTable dt = BOL.PatientOrder.InitializePatientOrderTable();
			Assert.IsTrue(dt.Columns.Count > 0);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InitializePatientOrderTable_Fail()
		{
		}

		

		


		[Test]
		public void DivisionCode_Get()
		{
			string code=this._tstPO.DivisionCode;

			Assert.AreEqual(this._tstPO.DivisionCode, code); 
		}

		[Test]
		public void DivisionCode_Set()
		{
			BOL.PatientOrder _tmpPO = new BOL.PatientOrder(__tstPOGuid, false);
			
			_tmpPO.DivisionCode=Common.LogonUser.LogonUserDivisionCode; 

			Assert.AreEqual(_tmpPO.DivisionCode, Common.LogonUser.LogonUserDivisionCode);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void DivisionCode_Set_Fail()
		{			
			BOL.PatientOrder _tmpPO = new BOL.PatientOrder(__tstPOGuid, false);

			string code="1234567891011121314151617181920";

			_tmpPO.DivisionCode=code;

			Assert.AreEqual(_tmpPO.DivisionCode, code);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DivisionCode_Get_Fail()
		{			
		}

		[Test]
		public void LastUpdateDate_Get()
		{
			DateTime tmpDate=this._tstPO.LastUpdateDate;

			Assert.AreEqual(this._tstPO.LastUpdateDate, tmpDate); 
		}

		[Test]
		public void LastUpdateDate_Set()
		{
			BOL.PatientOrder _tmpPO = new BOL.PatientOrder(__tstPOGuid, false);
			
			DateTime tmpDate=DateTime.Now;

			_tmpPO.LastUpdateDate=tmpDate; 

			Assert.AreEqual(_tmpPO.LastUpdateDate, tmpDate);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void LastUpdateDate_Set_Fail()
		{			
			BOL.PatientOrder _tmpPO = new BOL.PatientOrder(__tstPOGuid, false);
			
			DateTime tmpDate=DateTime.MinValue;

			_tmpPO.LastUpdateDate=tmpDate; 

			Assert.AreEqual(_tmpPO.LastUpdateDate, tmpDate);
		}

		[Test]
		public void LastUpdateUser_Get()
		{
			String luu=this._tstPO.LastUpdateUser;

			Assert.AreEqual(this._tstPO.LastUpdateUser, luu); 
		}

		[Test]
		public void LastUpdateUser_Set()
		{
			BOL.PatientOrder _tmpPO = new BOL.PatientOrder(__tstPOGuid, false);
			
			String luu=Common.LogonUser.LogonUserName;

			_tmpPO.LastUpdateUser=luu;

			Assert.AreEqual(_tmpPO.LastUpdateUser, luu);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void LastUpdateUser_Set_Fail1()
		{			
			BOL.PatientOrder _tmpPO = new BOL.PatientOrder(__tstPOGuid, false);
			
			_tmpPO.LastUpdateUser=null; 

			Assert.AreEqual(_tmpPO.LastUpdateUser, null);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void LastUpdateUser_Set_Fail2()
		{			
			BOL.PatientOrder _tmpPO = new BOL.PatientOrder(__tstPOGuid, false);
			
			String luu="12345678910111213141516171819201234567891011121314151617181920";

			_tmpPO.LastUpdateUser=luu;

			Assert.AreEqual(_tmpPO.LastUpdateUser, luu);
		}

		[Test]
		public void RowVersion_Get()
		{
			byte[] version=this._tstPO.RowVersion;

			Assert.AreEqual(this._tstPO.RowVersion, version); 
		}

		[Test]
		public void RowVersion_Set()
		{
			BOL.PatientOrder _tmpPO = new BOL.PatientOrder(__tstPOGuid, false);
			
			byte [] version=new byte[8];

			_tmpPO.RowVersion=version;

			Assert.AreEqual(_tmpPO.RowVersion, version);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void RowVersion_Set_Fail1()
		{			
			BOL.PatientOrder _tmpPO = new BOL.PatientOrder(__tstPOGuid, false);
			
			_tmpPO.RowVersion=null; 

			Assert.AreEqual(_tmpPO.RowVersion, null);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void RowVersion_Set_Fail2()
		{			
			BOL.PatientOrder _tmpPO = new BOL.PatientOrder(__tstPOGuid, false);
			
			byte[] version=new byte[9];

			_tmpPO.RowVersion=version;

			Assert.AreEqual(_tmpPO.RowVersion, version);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]			
		public void PrintPatientOrderAlert_Cprs_Pass()
		{ 
			//Printed materials
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]			
		public void PrintPatientOrderAlert_Cprs_Fail()
		{
			//Printed materials
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]			
		public void PrintPatientOrderAlert_Pass()
		{ 
			//Printed materials
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]			
		public void PrintPatientOrderAlert_Fail()
		{
			//Printed materials
		}

		[Test]
		public void GetReflexTestsForOrder_Pass()
		{ 
			System.Guid otGuid = DataCreator.GetRecordGuid("SELECT TOP 1 OrderedTestGuid FROM SpecimenTest WHERE OrderedTestGuid IS NOT NULL AND DivisionCode = '" + this.TestDivisionCode + "'");
 
			DataTable dtTest = BOL.PatientOrder.GetReflexTestsForOrder(otGuid);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetReflexTestsForOrder_Fail()
		{
			DataTable dtTest = BOL.PatientOrder.GetReflexTestsForOrder(System.Guid.Empty);
		}

		[Test]
		public void PatientTreatmentGuid_Pass()
		{
			Guid test = Guid.NewGuid();
			//
			_tstPO = new BOL.PatientOrder(this.__tstPOGuid, false);
			this._tstPO.PatientTreatmentGuid = test;
			//
			Assert.IsTrue( this._tstPO.PatientTreatmentGuid.Equals( test ) );
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void PatientTreatmentGuid_Fail()
		{
			Guid test = Guid.NewGuid();
			//
			_tstPO = new BOL.PatientOrder(this.__tstPOGuid, true);
			this._tstPO.PatientTreatmentGuid = test;
			//
			Assert.IsTrue( this._tstPO.PatientTreatmentGuid.Equals( test ) );
		}
	}
}
#endif
